#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Hamster GridMod01.fsh   by     starmole2
//https://www.shadertoy.com/view/dstSz2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float sawtooth(float t, float width) {
    // sawtooth wave, [0..1], pulse of width
    // 1| / / /
    //  |/ / /
    //  0--w--->
    return fract(t / width);
}

float triangle(float t, float width) {
    // triangle wave, [0..1], pulse of width
    // 1| /\  /\
    //  |/  \/  \
    //  0----w---->
    float s = sawtooth(t, width) * 2.0;
    return (s>1.0)?2.0-s:s; 
}

float square(float t, float width) {
    // square wave, [0..1], pulse of width
    // 1|--  --
    //  |  __  __
    //  0----w---->
    float s = sawtooth(t, width);
    return (s>.5)?1.0:0.0;
}

float rectangle(float t, float width, float highwidthrel) {
    // square wave, [0..1], pulse of width
    // 1|--  --
    //  |  __  __
    //  0--h-w---->
    float s = sawtooth(t, width);
    return (s>1.0-highwidthrel)?1.0:0.0;
}

float smoothsquare(float t, float width, float edgewidthrel ) {
    // smoothed square wave, [0..1], pulse of width
    // smooth edge width edgewidth [0..width]. 
    // 1|--    --
    //  |  \__/  \__
    //  0--e--w------->
    // if edgewidth = 0, same as a square wave
    // if edgewidth = width, same as triangle wave 
    edgewidthrel *= .5;
    return smoothstep(.5-edgewidthrel,.5+edgewidthrel,triangle(t,width));
}

float smoothrectangle(float t, float width, float highwidthrel, float edgewidthrel ) {
    // mix of rectangle and smoothsquare 
    edgewidthrel *= .5;
    float em = 1.0 - highwidthrel;
    return smoothstep(em-edgewidthrel,em+edgewidthrel,triangle(t,width));
}

float cosine(float t, float width) {
     // cosine wave, [0..1], pulse of width
    // 1|-   -   -
    //  | \_/ \_/
    //  0----w----->
    return cos((t/width)*6.28318530)*.5+.5;
}

vec2 pinch(vec2 uv, vec2 center, float outerr, float innerr, float amount) {
    vec2 uv2 = uv - center;
    float d = length(uv2);
    float s = (d-innerr) / (outerr-innerr);
    s =  clamp(s, 0.0, 1.0);
    s = 1.0 - cosine(s, 1.0);
    uv2 += (uv2/d)*s*amount; 
    return uv2 + center;
}

float softxor(float a , float b) {
    float xa = a * (1.0-b); // only 1 if a==1 && b==0
    float xb = b * (1.0-a); // only 1 if a==0 && b==1
    return max(xa,xb);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates
    vec2 uv0 = fragCoord/iResolution.xy * 2.0 - 1.0;
    vec2 uv = uv0;
    float aspect = iResolution.x / iResolution.y;
    uv.x *= aspect;   
    
    vec2 m = iMouse.xy / iResolution.xy * 2.0 - 1.0;
    m = clamp(m, vec2(-1.0), vec2(1.0));
    m.x *= aspect;
    
    vec2 mr = vec2(m.y,-m.x);
    
    m.x += sin(iTime*.5);
    m.y += cos(iTime*.33);
    mr.x += sin(iTime*-.1);
    mr.y += cos(iTime*.27);
    
#if 1
    // nice shapes
    vec2 uv2 = pinch(uv, m, 4.0, .012, 1.95);
    uv2 = pinch(uv2, mr, 5.0, .22, -1.85);
    uv2 *= 8.0;
#else
    // perspective test
    vec2 uv2 = uv - m;
    uv2 *= 10.0;
    uv2.x /= uv2.y;
#endif

    vec2 duvx = abs(dFdx(uv2));
    vec2 duvy = abs(dFdy(uv2));
    
    float maxdu = max(duvx.x, duvy.x);
    float maxdv = max(duvx.y, duvy.y);

    float linew = 3.0;
    float smoothw = 4.0;

#if 1
    // lines
    float c = smoothrectangle(uv2.x, 1.0, maxdu*linew, maxdu*smoothw);
    float c2 = smoothrectangle(uv2.y, 1.0, maxdv*linew, maxdv*smoothw);
    c = max(c,c2);
#else
    // checkerboard
    float c = smoothrectangle(uv2.x, 1.0, .5, maxdu*smoothw);
    float c2 = smoothrectangle(uv2.y, 1.0, .5, maxdv*smoothw);
    c = softxor(c,c2);
#endif    
    c = clamp(c, 0.0, 1.0);
    vec3 col = vec3(1.0-c);
   
 
    // Output to screen
    fragColor = vec4(pow(col, vec3(1.0/2.2)),1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

